/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.gui;

import com.lothrazar.cyclic.registry.TextureRegistry;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;

public class TimerBar {
    private AbstractContainerScreen<?> parent;
    private int x = 20;
    private int y = 98;
    public int capacity;
    public int width = 26;
    private int height = 14;
    public int guiLeft;
    public int guiTop;
    public boolean showText = true;
    public boolean visible = true;

    public TimerBar(AbstractContainerScreen<?> parent, int x, int y, int cap) {
        this.parent = parent;
        this.x = x;
        this.y = y;
        this.capacity = cap;
    }

    public boolean isMouseover(int mouseX, int mouseY) {
        return this.guiLeft + this.x < mouseX && mouseX < this.guiLeft + this.x + this.width && this.guiTop + this.y < mouseY && mouseY < this.guiTop + this.y + this.height;
    }

    public void draw(PoseStack ms, float timer) {
        if (!this.visible) {
            return;
        }
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TextureRegistry.PROGRESS);
        float pct = Math.min(timer / (float)this.capacity, 1.0f);
        Screen.m_93133_((PoseStack)ms, (int)(this.guiLeft + this.x), (int)(this.guiTop + this.y), (float)0.0f, (float)0.0f, (int)((int)((float)this.width * pct)), (int)this.height, (int)this.width, (int)this.height);
        if (this.showText) {
            Minecraft.m_91087_().f_91062_.m_92883_(ms, "[" + (int)timer + "]", (float)(this.guiLeft + this.x + 2), (float)(this.guiTop + this.y + 4), 4209792);
        }
    }

    public void renderHoveredToolTip(PoseStack ms, int mouseX, int mouseY, int curr) {
        if (this.isMouseover(mouseX, mouseY) && this.visible) {
            Object display = "";
            int seconds = curr / 20;
            if (curr > 2400) {
                int minutes = seconds / 60;
                int remainder = seconds % 60;
                display = minutes + "m " + remainder + "s";
            } else {
                display = curr > 400 ? seconds + "s" : "" + curr;
            }
            ArrayList<TranslatableComponent> list = new ArrayList<TranslatableComponent>();
            list.add(new TranslatableComponent((String)display));
            this.parent.m_96597_(ms, list, mouseX, mouseY);
        }
    }
}

